package ru.yandex.webmaster3.storage.verification;

import java.util.Optional;
import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.host.verification.IUserHostVerifier;
import ru.yandex.webmaster3.core.host.verification.VerificationCausedBy;
import ru.yandex.webmaster3.core.host.verification.VerificationFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.IDMVerificationCancelledFailInfo;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.storage.admin.IDMVerificationRecord;
import ru.yandex.webmaster3.storage.admin.dao.IDMVerificationsYDao;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;

/**
 * @author avhaliullin
 */
public class IDMVerifier implements IUserHostVerifier {
    @Autowired
    private IDMVerificationsYDao iDMVerificationsYDao;

    @Override
    public Optional<VerificationFailInfo> verify(long userId, WebmasterHostId hostId, UUID recordId, long verificationUin, VerificationCausedBy verificationCausedBy) {
        try {
            IDMVerificationRecord verificationRecord = iDMVerificationsYDao.getVerificationForUserAndHost(userId, hostId);
            if (verificationRecord == null) {
                return Optional.of(new IDMVerificationCancelledFailInfo());
            }
            return Optional.empty();
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Failed to check idm verification",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }

    @Override
    public boolean isApplicable(WebmasterHostId hostId, long userId) {
        return true;
    }
}
