package ru.yandex.webmaster3.storage.verification;

import java.util.Optional;
import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.host.verification.IUserHostVerifier;
import ru.yandex.webmaster3.core.host.verification.VerificationCausedBy;
import ru.yandex.webmaster3.core.host.verification.VerificationFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.PDDVerificationCancelledFailInfo;
import ru.yandex.webmaster3.storage.user.dao.UserHostVerificationYDao;

import static ru.yandex.webmaster3.core.host.verification.VerificationCausedBy.REGULAR_RECHECK;

/**
 * @author avhaliullin
 */
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class PDDVerifier implements IUserHostVerifier {
    private final UserHostVerificationYDao userHostVerificationYDao;

    @Override
    public Optional<VerificationFailInfo> verify(long userId, WebmasterHostId hostId, UUID recordId, long verificationUin, VerificationCausedBy verificationCausedBy) {
        var verificationInfo = userHostVerificationYDao.getRecord(userId, hostId, recordId);
        if (verificationInfo != null && verificationInfo.getVerificationCausedBy() == REGULAR_RECHECK) {
            // WMC-7524: ПДД закрыли, поэтому чтобы не ломать перепроверку
            // уже подтвержденных хостов, возвращаем что проверка прошла успешна
            return Optional.empty();
        } else {
            return Optional.of(new PDDVerificationCancelledFailInfo());
        }
    }

    @Override
    public boolean isApplicable(WebmasterHostId hostId, long userId) {
        // сделаем недоступной пользователям
        return false;
    }
}
