package ru.yandex.webmaster3.storage.verification;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.host.verification.IUserHostVerifier;
import ru.yandex.webmaster3.core.host.verification.VerificationCausedBy;
import ru.yandex.webmaster3.core.host.verification.VerificationFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.SelfVerificationCancelled;

import java.util.Optional;
import java.util.UUID;

/**
 * @author avhaliullin
 */
public class UnknownVerifier implements IUserHostVerifier {
    @Override
    public Optional<VerificationFailInfo> verify(long userId, WebmasterHostId hostId, UUID recordId, long verificationUin, VerificationCausedBy verificationCausedBy) {
        return Optional.of(new SelfVerificationCancelled());
    }

    @Override
    public boolean isApplicable(WebmasterHostId hostId, long userId) {
        return true;
    }
}
