package ru.yandex.webmaster3.storage.verification.whois;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author avhaliullin
 */
public class ContactInfoWhoisHandler implements WhoisRecordHandler {
    private static final Pattern CONTACT_PATTERN = Pattern.compile("^(?:.*\\s)contact(.*):\\s*$", Pattern.CASE_INSENSITIVE);
    private static final Pattern CONTACT_EMAIL_INFO_PATTERN = Pattern.compile(".+\\s[(<]?([\\w._%+-]+@[\\w0-9.-]+\\.[\\w]{2,4})[)>]?\\s*$");

    private boolean readingContactInfo = false;

    @Override
    public String nextLine(String line) {
        if (readingContactInfo) {
            Matcher m = CONTACT_EMAIL_INFO_PATTERN.matcher(line);
            if (m.find()) {
                return m.group(1);
            }
        }
        if (CONTACT_PATTERN.matcher(line).find()) {
            readingContactInfo = true;
        }
        if (readingContactInfo && line.trim().isEmpty()) {
            readingContactInfo = false;
        }
        return null;
    }
}
