package ru.yandex.webmaster3.storage.verification.whois;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author avhaliullin
 */
public class SimpleWhoisHandler implements WhoisRecordHandler {
    private static final Pattern EMAIL_PATTERN = Pattern.compile(
            "(?:.*\\s)?" + // любой префикс
                    "e-?mail(?: address)?\\.*:?[\\s.]*\\b" + // упоминание слова email (email address)
                    "([\\w._%+-]+@[\\w0-9.-]+\\.[\\w]{2,4})\\b" // ослабленная регулярка для email'а
            , Pattern.CASE_INSENSITIVE);

    private static final Pattern BLACK_LIST_PATTERN = Pattern.compile(
            "registrar .*email"
            ,Pattern.CASE_INSENSITIVE
    );

    @Override
    public String nextLine(String line) {
        if (BLACK_LIST_PATTERN.matcher(line).find()){
            return null;
        }
        Matcher m = EMAIL_PATTERN.matcher(line);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}
