package ru.yandex.webmaster3.storage.video;
import ru.yandex.webmaster3.core.util.enums.EnumResolver;
import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * @author vsedaikina
 * 20.10.21
 */
public enum OfferStatus {
    @Description("No offer")
    NO_OFFER,
    @Description("Offer is checked and valid")
    CONFIRMED,
    @Description("Offer is checking")
    IN_PROGRESS,
    @Description("Offer is invalid")
    FAILED,
    @Description("Offer has been removed")
    REMOVED,
    @Description("Need additional paper agreement")
    NEED_PAPER,
    @Description("Has additional paper agreement")
    HAS_PAPER,
    @Description("Offer or additional agreement is not needed")
    REDUNDANT,
    ;

    public static final EnumResolver<OfferStatus> R = EnumResolver.er(OfferStatus.class);
}
