package ru.yandex.webmaster3.storage.video;

import com.google.common.base.Strings;
import lombok.Builder;
import lombok.Value;
import org.joda.time.DateTime;

/**
 * @author vsedaikina
 * 18.10.21
 */
@Value
@Builder(toBuilder = true)
public class VideohostOffer {
    String hostUrl;
    String offerUrl;
    OfferStatus status;
    DateTime addDate;
    OfferErrorType error;
    String comments;
    DateTime updateDate;

    public OfferErrorType getError() {
        return (error == null) ? OfferErrorType.EMPTY : error;
    }

    public String getComments() {
        return Strings.nullToEmpty(comments);
    }
}
