package ru.yandex.webmaster3.storage.video;

import java.util.List;
import java.util.function.Consumer;

import lombok.Value;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.ValueDataMapper;

/**
 * @author vsedaikina
 * 08.11.21
 */
@Repository
public class VideohostOfferVideohostsYDao extends AbstractYDao {

    protected VideohostOfferVideohostsYDao() {
        super(PREFIX_VIDEO, "videohost_offers_videohosts");
    }

    public void insert(String hostUrl, long cnt, long sum_tvt) {
        upsert(
                F.HOST_URL.value(hostUrl),
                F.CNT.value(cnt),
                F.SUM_TVT.value(sum_tvt)
        ).execute();
    }

    public void forEach(Consumer<VideoHostInfo> consumer) {
        streamReader(DataMapper.create(F.HOST_URL, F.CNT, F.SUM_TVT, VideoHostInfo::new), consumer);
    }

    public boolean contains(String hostUrl) {
        return select(F.HOST_URL).where(F.HOST_URL.eq(hostUrl)).queryOne() != null;
    }

    public void batchInsert(List<VideoHostInfo> items) {
        batchInsert(VALUE_MAPPER, items).execute();
    }

    private static final ValueDataMapper<VideoHostInfo> VALUE_MAPPER = ValueDataMapper.create2(
            Pair.of(F.HOST_URL, VideoHostInfo::getHostUrl),
            Pair.of(F.CNT, VideoHostInfo::getCnt),
            Pair.of(F.SUM_TVT, VideoHostInfo::getSumTvt)
    );

    private interface F {
        Field<String> HOST_URL = Fields.stringField("host_url");
        Field<Long> CNT = Fields.longField("cnt");
        Field<Long> SUM_TVT = Fields.longField("sum_tvt");
    }

    @Value
    public static class VideoHostInfo {
        String hostUrl;
        long cnt;
        long sumTvt;
    }
}
