package ru.yandex.webmaster3.storage.yql;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors.FileDescriptor;

/**
 * @author avhaliullin
 */
public class YqlFunctions {
    public static final YqlFunctionDef URL_2_HOST_ID = new YqlFunctionDef(
            "$fixScheme = Re2::Replace(\"://\");\n" +
                    "$getScheme = ($url) -> {\n" +
                    "  return $fixScheme(NVL(Url::GetScheme($url), \"http\"), \"\");\n" +
                    "};\n" +
                    "$getPort = ($url) -> {\n" +
                    "  return NVL(Url::GetPort($url), IF($getScheme($url) == \"http\", 80, 443));\n" +
                    "};\n" +
                    "$url2HostId = ($url) -> {\n" +
                    "  return $getScheme($url) || \":\" || Url::GetHost($url) || \":\" || YQL::ToString($getPort($url));\n" +
                    "};\n"
    );

    public static final YqlFunctionDef ESCAPE = new YqlFunctionDef("" +
            "$escape = ($s) -> {\n" +
            "   return String::ReplaceAll(String::ReplaceAll(String::ReplaceAll(String::ReplaceAll($s, @@\\@@, @@\\\\@@), '\\r', '\\\\r'), '\\n', '\\\\n'), '\\t', '\\\\t');\n" +
            "};\n"
    );

    public static YqlFunctionCall url2HostId(String urlArg) {
        return new YqlFunctionCall(URL_2_HOST_ID, "$url2HostId(" + urlArg + ")");
    }

    public static final YqlFunctionDef CUT_WWW_AND_M =
            new YqlFunctionDef("$CutWWWM = Re2::Capture(\"^(www\\\\.|m\\\\.)?(.+)$\");\n");

    public static YqlFunctionCall cutWwwAndM(String arg) {
        return new YqlFunctionCall(CUT_WWW_AND_M, "$CutWWWM(" + arg + ")");
    }

    /**
     * https://yql.yandex.net/docs/yt/misc/schema/#95yql95proto95field
     */
    public static final YqlFunctionDef protoDefinition(String message, String meta) {
        String config = "$config_" + message.replaceAll("\\.", "_");
        String parse = "$parse_" + message.replaceAll("\\.", "_");
        return new YqlFunctionDef(config + " = AsAtom(@@{" +
                "\"name\":\"" + message + "\",\n" +
                "\"meta\":\"" + meta + "\"}@@);\n\n" +
                parse + " = YQL::Udf(AsAtom(\"Protobuf.Parse\"), YQL::Void(), YQL::Void(), " + config + ");\n\n");
    }

    public static final YqlFunctionCall parseProto(String message, String meta, String arg) {
        String parse = "$parse_" + message.replaceAll("\\.", "_");
        return new YqlFunctionCall(protoDefinition(message, meta), parse + "(" + arg + ")");
    }

    // FileDescriptorSet, сериализованный, сжатый и упакованный в Base64, как раз для YQL
    public static String protoMeta(FileDescriptor fileDescriptor) {
        Set<FileDescriptor> files = new LinkedHashSet<>();
        collectDependencies(fileDescriptor, files);
        DescriptorProtos.FileDescriptorSet.Builder result = DescriptorProtos.FileDescriptorSet.newBuilder();
        files.stream().map(FileDescriptor::toProto).forEach(result::addFile);
        DescriptorProtos.FileDescriptorSet descriptorSet = result.build();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DeflaterOutputStream compressed = new DeflaterOutputStream(baos)){
            descriptorSet.writeTo(compressed);
        } catch (IOException e) {
            // should never happen
            throw new RuntimeException("Error writing to deflate stream", e);
        }
        byte[] bytes = Base64.getEncoder().encode(baos.toByteArray());
        return new String(bytes);
    }

    private static void collectDependencies(FileDescriptor current, Set<FileDescriptor> result) {
        if (!result.contains(current)) {
            for (FileDescriptor dependency : current.getDependencies()) {
                collectDependencies(dependency, result);
            }
            result.add(current);
        }
    }
}
