package ru.yandex.webmaster3.storage.ytimport;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum TableStatus implements IntEnum {
    UNKNOWN(0),

    NEW(1),
    QUEUED(2),
    IMPORTED(3),
    OBSOLETE(4)
    ;

    private final int value;

    TableStatus(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static IntEnumResolver<TableStatus> R = IntEnumResolver.r(TableStatus.class);
}
