package ru.yandex.webmaster3.storage.ytimport;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * Статус задачи импорта поисковых запросов
 * @author Oleg Bazdyrev
 */
public enum YtClickhouseDataLoadState {

    INITIALIZING(false),
    PREPARING(false),
    IMPORTING(false),
    WAITING_FOR_IMPORT(false),
    REPLICATING(false),
    WAITING_FOR_REPLICATION(false),
    CLEANING(false),
    RENAMING(false),
    CREATING_DISTRIBUTED(false),
    DONE(true),
    FAILED(true),
    ;

    private final boolean terminal;

    YtClickhouseDataLoadState(boolean terminal) {
        this.terminal = terminal;
    }

    public boolean isTerminal() {
        return terminal;
    }

    public static final EnumResolver<YtClickhouseDataLoadState> R = EnumResolver.er(YtClickhouseDataLoadState.class);

}
