package ru.yandex.webmaster3.storage.ytimport;

import java.util.List;
import java.util.UUID;

/**
 * @author avhaliullin
 */
public class YtClickhouseImportCommand {
    private final UUID taskId;
    private final List<YtClickhouseTableRelation> tables;
    private final String database;
    private final String tableInsertSpec;
    private final ImportPriority priority;

    public YtClickhouseImportCommand(UUID taskId, List<YtClickhouseTableRelation> tables, String database, String tableInsertSpec, ImportPriority priority) {
        this.taskId = taskId;
        this.tables = tables;
        this.database = database;
        this.tableInsertSpec = tableInsertSpec;
        this.priority = priority;
    }

    public UUID getTaskId() {
        return taskId;
    }

    public List<YtClickhouseTableRelation> getTables() {
        return tables;
    }

    public String getDatabase() {
        return database;
    }

    public String getTableInsertSpec() {
        return tableInsertSpec;
    }

    public ImportPriority getPriority() {
        return priority;
    }
}
