package ru.yandex.webmaster3.storage.ytimport;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.type.TypeReference;

import ru.yandex.webmaster3.storage.util.yt.YtPath;

/**
 * @author avhaliullin
 */
public class YtClickhouseTableRelation {

    public static final TypeReference<List<YtClickhouseTableRelation>> LIST_REFERENCE = new TypeReference<>() {
    };

    private final YtPath ytTable;
    private final int clickhouseShard;
    private final String clickhouseTableName;
    private final String clickhouseTableCreateSpec;

    @JsonCreator
    public YtClickhouseTableRelation(YtPath ytTable, int clickhouseShard, String clickhouseTableName, String clickhouseTableCreateSpec) {
        this.clickhouseShard = clickhouseShard;
        this.ytTable = ytTable;
        this.clickhouseTableName = clickhouseTableName;
        this.clickhouseTableCreateSpec = clickhouseTableCreateSpec;
    }

    public int getClickhouseShard() {
        return clickhouseShard;
    }

    public YtPath getYtTable() {
        return ytTable;
    }

    public String getClickhouseTableName() {
        return clickhouseTableName;
    }

    public String getClickhouseTableCreateSpec() {
        return clickhouseTableCreateSpec;
    }
}
