package ru.yandex.webmaster3.tanker;

import ru.yandex.webmaster3.core.notification.LanguageEnum;
import ru.yandex.webmaster3.tanker.I18nMonthsGenitive;
import ru.yandex.webmaster3.tanker.I18nMonthsGenitiveShort;
import ru.yandex.webmaster3.tanker.I18nMonthsNominativeShort;

import java.util.EnumSet;
import java.util.Set;

/**
 * @author avhaliullin
 */
public class TankerCommonTexts {
    private static final Set<LanguageEnum> UPPER_CASE_MONTHS = EnumSet.of(LanguageEnum.EN);

    public static String monthShortNominative(LanguageEnum lang, int monthNumber) {
        return I18nMonthsNominativeShort.fromEnum(TankerMonthEnum.fromInt(monthNumber)).getText(lang);
    }

    public static String monthShortGenitive(LanguageEnum lang, int monthNumber) {
        return I18nMonthsGenitiveShort.fromEnum(TankerMonthEnum.fromInt(monthNumber)).getText(lang);
    }

    public static String monthGenitiveUpperCase(LanguageEnum lang, int monthNumber) {
        return I18nMonthsGenitive.fromEnum(TankerMonthEnum.fromInt(monthNumber)).getText(lang);
    }

    public static String monthGenitiveLowerCase(LanguageEnum lang, int monthNumber) {
        String upperCaseMonth = monthGenitiveUpperCase(lang, monthNumber);
        if (UPPER_CASE_MONTHS.contains(lang)) {
            return upperCaseMonth;
        } else {
            return upperCaseMonth.toLowerCase(lang.getL10n().getLocale());
        }
    }
}
