package ru.yandex.webmaster3.tanker;

import ru.yandex.webmaster3.core.notification.LanguageEnum;
import ru.yandex.webmaster3.tanker.internal.TankerLangUtil;
import ru.yandex.webmaster3.tanker.internal.TankerTemplateEntry;

import java.util.List;
import java.util.Map;


/**
 * @author avhaliullin
 */
public class TankerDynamicKey {
    private final Map<LanguageEnum, List<TankerTemplateEntry>> templates;

    public TankerDynamicKey(Map<LanguageEnum, List<TankerTemplateEntry>> templates) {
        this.templates = templates;
    }

    public List<TankerTemplateEntry> getTemplate(LanguageEnum language) {
        return templates.get(TankerLangUtil.getSupportedLanguage(language));
    }

}
