package ru.yandex.webmaster3.tanker;

import ru.yandex.webmaster3.core.notification.LanguageEnum;
import ru.yandex.webmaster3.tanker.internal.TankerTemplateEntry;

import java.util.List;
import java.util.Map;
import java.util.function.Function;

/**
 * @author avhaliullin
 */
public class TankerDynamicKeyWithBuilder<Builder> extends TankerDynamicKey implements TankerKeyWithBuilder<Builder> {
    private final Function<List<TankerTemplateEntry>, Builder> builderFactory;

    public TankerDynamicKeyWithBuilder(Map<LanguageEnum, List<TankerTemplateEntry>> templates, Function<List<TankerTemplateEntry>, Builder> builderFactory) {
        super(templates);
        this.builderFactory = builderFactory;
    }

    @Override
    public Builder newBuilder(LanguageEnum language) {
        return builderFactory.apply(getTemplate(language));
    }

}
