package ru.yandex.webmaster3.tanker;

import ru.yandex.webmaster3.core.notification.LanguageEnum;
import ru.yandex.webmaster3.core.text.templates.RenderableText;
import ru.yandex.webmaster3.tanker.internal.TankerLangUtil;
import ru.yandex.webmaster3.tanker.internal.TankerTemplateEntry;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class TankerStaticKey extends TankerDynamicKey {
    private final Map<LanguageEnum, String> texts;

    public TankerStaticKey(Map<LanguageEnum, String> texts) {
        super(generateTemplates(texts));
        this.texts = texts;
    }

    private static Map<LanguageEnum, List<TankerTemplateEntry>> generateTemplates(Map<LanguageEnum, String> texts) {
        Map<LanguageEnum, List<TankerTemplateEntry>> result = new HashMap<>();
        for (Map.Entry<LanguageEnum, String> entry : texts.entrySet()) {
            result.put(entry.getKey(), Collections.singletonList(new TankerTemplateEntry.TextEntry(entry.getValue())));
        }
        return result;
    }

    public String getText(LanguageEnum languageEnum) {
        return texts.get(TankerLangUtil.getSupportedLanguage(languageEnum));
    }

    public RenderableText createRenderableText(LanguageEnum language) {
        return new RenderableText() {
            @Override
            public String render() {
                return getText(language);
            }

            @Override
            public void renderTo(StringBuilder sb) {
                sb.append(getText(language));
            }
        };
    }
}
