package ru.yandex.webmaster3.tanker.digest.html;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author avhaliullin
 */
public class CSS {
    private final Map<String, String> rules = new HashMap<>();

    public CSS set(String name, String value) {
        rules.put(name, value);
        return this;
    }

    public CSS width(HtmlSize size) {
        rules.put("width", size.serialize());
        return this;
    }

    public CSS add(CSS other) {
        rules.putAll(other.rules);
        return this;
    }

    public String serialize() {
        Comparator<Map.Entry<String, String>> comp = Comparator.comparing(o -> (o.getKey()));
        return rules.entrySet().stream()
                .sorted(comp)
                .map(e -> e.getKey() + ":" + e.getValue())
                .collect(Collectors.joining(";"));
    }

    public static CSS create() {
        return new CSS();
    }
}
