package ru.yandex.webmaster3.tanker.digest.html;

/**
 * @author avhaliullin
 */
public class HtmlSize {
    private final String value;

    private HtmlSize(String value) {
        this.value = value;
    }

    public static HtmlSize px(int amount) {
        if (amount == 0) {
            return ZERO;
        }
        return new HtmlSize(amount + "px");
    }

    public static HtmlSize percent(int amount) {
        return new HtmlSize(amount + "%");
    }

    public String serialize() {
        return value;
    }

    public static HtmlSize ZERO = new HtmlSize("0");
}
