package ru.yandex.webmaster3.tanker.internal;

import org.joda.time.base.AbstractInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import ru.yandex.webmaster3.core.util.TimeUtils;
import ru.yandex.webmaster3.tanker.digest.html.HtmlNode;

/**
 * @author avhaliullin
 */
public class TankerFieldFormats {
    private static DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern("yyyy-MM-dd");
    private static DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm");

    public static String dateToString(AbstractInstant instant) {
        return instant == null ? null : instant.toDateTime(TimeUtils.EUROPE_MOSCOW_ZONE).toString(DATE_FORMAT);
    }

    public static String dateTimeToString(AbstractInstant instant) {
        return instant == null ? null : instant.toDateTime(TimeUtils.EUROPE_MOSCOW_ZONE).toString(DATE_TIME_FORMAT);
    }

    public static HtmlNode dateToHtml(AbstractInstant instant) {
        return HtmlNode.safeText(dateToString(instant));
    }

    public static HtmlNode dateTimeToHtml(AbstractInstant instant) {
        return HtmlNode.safeText(dateTimeToString(instant));
    }

    public static HtmlNode stringToHtml(String s) {
        return HtmlNode.text(s);
    }
}
