package ru.yandex.webmaster3.tanker.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class TankerPlaceholders<T> {
    private final Map<String, T> phs = new HashMap<>();
    private final Map<String, Long> numbers = new HashMap<>();

    public TankerPlaceholders<T> putNumber(String key, long value) {
        numbers.put(key, value);
        return this;
    }

    public long getNumber(String key) {
        return numbers.get(key);
    }

    public TankerPlaceholders<T> put(String key, T value) {
        this.phs.put(key, value);
        return this;
    }

    public Map<String, T> getPhs() {
        return Collections.unmodifiableMap(phs);
    }

    public T get(String key) {
        return phs.get(key);
    }

    public T getOrDefault(String key, T defaultValue) {
        return phs.getOrDefault(key, defaultValue);
    }
}
