package ru.yandex.webmaster3.tanker.internal;

import java.util.ArrayList;
import java.util.List;

/**
 * @author avhaliullin
 */
public abstract class TankerTemplateEntry {
    public static class TextEntry extends TankerTemplateEntry {
        private final String text;

        public TextEntry(String text) {
            this.text = text;
        }

        public String getText() {
            return text;
        }
    }

    public static class PlaceholderEntry extends TankerTemplateEntry {
        private final String placeholder;

        public PlaceholderEntry(String placeholder) {
            this.placeholder = placeholder;
        }

        public String getPlaceholder() {
            return placeholder;
        }
    }

    public static class ConditionalEntry extends TankerTemplateEntry {
        private final String condition;
        private final List<TankerTemplateEntry> trueEntries = new ArrayList<>();
        private final List<TankerTemplateEntry> falseEntries = new ArrayList<>();

        public ConditionalEntry(String condition) {
            this.condition = condition;
        }

        public String getCondition() {
            return condition;
        }

        public List<TankerTemplateEntry> getTrueEntries() {
            return trueEntries;
        }

        public List<TankerTemplateEntry> getFalseEntries() {
            return falseEntries;
        }

        public ConditionalEntry addTrueEntry(TankerTemplateEntry entry) {
            trueEntries.add(entry);
            return this;
        }

        public ConditionalEntry addFalseEntry(TankerTemplateEntry entry) {
            falseEntries.add(entry);
            return this;
        }
    }

    public static class PluralEntry extends TankerTemplateEntry {
        private final String countParam;
        private final List<TankerTemplateEntry> oneEntries = new ArrayList<>();
        private final List<TankerTemplateEntry> someEntries = new ArrayList<>();
        private final List<TankerTemplateEntry> manyEntries = new ArrayList<>();
        private final List<TankerTemplateEntry> noneEntries = new ArrayList<>();

        public PluralEntry(String countParam) {
            this.countParam = countParam;
        }

        public PluralEntry addOneEntry(TankerTemplateEntry entry) {
            this.oneEntries.add(entry);
            return this;
        }

        public PluralEntry addSomeEntry(TankerTemplateEntry entry) {
            this.someEntries.add(entry);
            return this;
        }

        public PluralEntry addManyEntry(TankerTemplateEntry entry) {
            this.manyEntries.add(entry);
            return this;
        }

        public PluralEntry addNoneEntry(TankerTemplateEntry entry) {
            this.noneEntries.add(entry);
            return this;
        }

        public String getCountParam() {
            return countParam;
        }

        public List<TankerTemplateEntry> getOneEntries() {
            return oneEntries;
        }

        public List<TankerTemplateEntry> getSomeEntries() {
            return someEntries;
        }

        public List<TankerTemplateEntry> getManyEntries() {
            return manyEntries;
        }

        public List<TankerTemplateEntry> getNoneEntries() {
            return noneEntries;
        }
    }
}
