package ru.yandex.webmaster3.validator.xml;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.FileParameter;
import ru.yandex.webmaster3.core.http.RequestFileProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.WebmasterUserIdAware;
import ru.yandex.webmaster3.core.validator.XmlValidatorSourceType;

import java.util.Optional;

/**
 * @author leonidrom
 */
public class ValidateXmlRequest implements ActionRequest {
    private String xml;
    private String xsd;
    private XmlValidatorSourceType xmlType;
    private XmlValidatorSourceType xsdType;
    private OutputFormat outputFormat = OutputFormat.XML;
    // ручка используется другими сервисами, поэтому user id может и не быть
    private Optional<Long> userId = Optional.empty();
    private FileParameter xmlFile;
    private FileParameter xsdFile;

    public String getXml() {
        return xml;
    }

    public String getXsd() {
        return xsd;
    }

    public XmlValidatorSourceType getXmlType() {
        return xmlType;
    }

    public XmlValidatorSourceType getXsdType() {
        return xsdType;
    }

    public OutputFormat getOutputFormat() {
        return outputFormat;
    }

    public FileParameter getXmlFile() {
        return xmlFile;
    }

    public FileParameter getXsdFile() {
        return xsdFile;
    }

    public Optional<Long> getUserId() {
        return userId;
    }

    @Description("XML для проверки")
    @RequestQueryProperty(required = true)
    public void setXml(String xml) {
        this.xml = xml;
    }

    @Description("Какой XSD использовать")
    @RequestQueryProperty(required = true)
    public void setXsd(String xsd) {
        this.xsd = xsd;
    }

    @Description("Тип XML источника")
    @RequestQueryProperty(required = true)
    public void setXmlType(XmlValidatorSourceType xmlType) {
        this.xmlType = xmlType;
    }

    @Description("Тип XSD источника")
    @RequestQueryProperty(required = true)
    public void setXsdType(XmlValidatorSourceType xsdType) {
        this.xsdType = xsdType;
    }

    @Description("")
    @RequestQueryProperty(required = false)
    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    @RequestFileProperty
    public void setXmlFile(FileParameter xmlFile) {
        this.xmlFile = xmlFile;
    }

    @RequestFileProperty
    public void setXsdFile(FileParameter xsdFile) {
        this.xsdFile = xsdFile;
    }

    @Description("id пользователя, если запрос инициирован пользователем")
    @RequestQueryProperty()
    public void setUserId(long userId) {
        this.userId = Optional.of(userId);
    }

    public enum OutputFormat {
        XML,
        JSON
    }
}
