package ru.yandex.webmaster3.validator.xml;

import lombok.Value;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * @author leonidrom
 */
public abstract class ValidateXmlResponse implements ActionResponse {
    public static class NormalResponse extends ValidateXmlResponse implements ActionResponse.NormalResponse {
        private final String output;

        NormalResponse(String output) {
            this.output = output;
        }

        @Description("Выхлоп валидатора")
        public String getOutput() {
            return output;
        }
    }

    public enum ValidateXmlErrorCode {
        GENERIC_ERROR,
        ;
    }

    public static class ValidateXmlErrorResponse extends ValidateXmlResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return ValidateXmlErrorCode.GENERIC_ERROR;
        }
    }

    @Value
    public static class XmlDownloadingErrorResponse extends ValidateXmlResponse implements ActionResponse.ErrorResponse {
        Integer httpCode;

        @Override
        public Enum<?> getCode() {
            return ErrorCode.XML_DOWNLOADING_FAILED;
        }

        @Override
        public String getMessage() {
            return "Не удалось скачать xml файл для валидации.";
        }
    }

    @Value
    public static class XsdDownloadingErrorResponse extends ValidateXmlResponse implements ActionResponse.ErrorResponse {
        Integer httpCode;

        @Override
        public Enum<?> getCode() {
            return ErrorCode.XSD_DOWNLOADING_FAILED;
        }

        @Override
        public String getMessage() {
            return "Не удалось скачать xsd файл.";
        }
    }

    public enum ErrorCode {
        XML_DOWNLOADING_FAILED,
        XSD_DOWNLOADING_FAILED,
        ;
    }
}
