package ru.yandex.webmaster3.viewer.http;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.storage.AbstractFilter;
import ru.yandex.webmaster3.viewer.http.host.verification.UsersVerifiedHostRequest;

import java.util.List;

/**
 * @author leonidrom
 */
public abstract class AbstractSamplesRequest<I extends Enum<I>, F extends AbstractFilter<I>> extends UsersVerifiedHostRequest implements PagerAware {
    private int p;
    private int pSize = 10;
    private List<F> parameterFilters;

    public int getP() {
        return p;
    }

    @Override
    public void setP(int p) {
        this.p = p;
    }

    public int getPSize() {
        return pSize;
    }

    @Override
    public void setPSize(int pSize) {
        this.pSize = pSize;
    }

    public List<F> getParameterFilters() {
        return parameterFilters;
    }

    @Description("фильтр по примерам")
    @RequestPostProperty
    public void setParameterFilters(List<F> parameterFilters) {
        this.parameterFilters = parameterFilters;
    }
}
