package ru.yandex.webmaster3.viewer.http;

import java.util.function.Function;

import lombok.Setter;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.sitestructure.SiteStructureService;
import ru.yandex.webmaster3.storage.user.dao.UserSiteTreeYDao;
import ru.yandex.webmaster3.storage.util.StructureFilterService;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.TextLikeCondition;

/**
 * @author avhaliullin
 */
public abstract class AbstractUrlFilteringAction<Req extends ActionRequest, Res extends ActionResponse> extends Action<Req, Res> {

    @Setter
    protected SiteStructureService siteStructureService;
    @Setter
    protected StructureFilterService structureFilterService;
    @Setter
    protected UserSiteTreeYDao userSiteTreeYDao;

    protected Condition getNodeCondition(Long nodeId, WebmasterHostId hostId, Function<TextLikeCondition.Builder, TextLikeCondition> pathConditionBuilder)  {
        return structureFilterService.getNodeCondition(nodeId, hostId, pathConditionBuilder);
    }

}
