package ru.yandex.webmaster3.viewer.http;

import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;
import ru.yandex.webmaster3.core.http.request.WebmasterUserIdAware;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public abstract class AbstractUserRequest extends AbstractFrontendRequest implements WebmasterUserIdAware {
    private long userId;
    private UUID userUUID;
    private WebmasterUser webmasterUser;

    @RequestQueryProperty(required = true)
    @Override
    public void setUserId(long userId) {
        this.userId = userId;
    }

    @Override
    public long getUserId() {
        return userId;
    }

    @Override
    @RequestQueryProperty
    public void setUserUUID(UUID userUUID) {
        this.userUUID = userUUID;
    }

    @Override
    public UUID getUserUUID() {
        return userUUID;
    }

    @Override
    public void setWebmasterUser(WebmasterUser user) {
        this.webmasterUser = user;
    }

    @Override
    public WebmasterUser getWebmasterUser() {
        return webmasterUser;
    }
}
