package ru.yandex.webmaster3.viewer.http;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.request.RequestIdAware;
import ru.yandex.webmaster3.core.searchquery.QueryGroup;
import ru.yandex.webmaster3.core.searchquery.QueryGroupId;
import ru.yandex.webmaster3.core.searchquery.viewer.QueryGroupConverter;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerQueryGroup;
import ru.yandex.webmaster3.storage.searchquery.QueryGroupService;
import ru.yandex.webmaster3.core.http.request.VerifiedHostIdAware;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author aherman
 */
public abstract class AbstractUserVerifiedHostAction<
        Request extends ActionRequest & RequestIdAware & VerifiedHostIdAware,
        Response extends ActionResponse
        >
        extends AbstractUserAction<Request, Response> {
    @NotNull
    protected static Map<QueryGroupId, ViewerQueryGroup> resolveQueryGroups(List<QueryGroupId> groupIds,
                                                                            QueryGroupService queryGroupService) {
        Map<QueryGroupId, ViewerQueryGroup> groups = new HashMap<>();
        for (QueryGroupId groupId : groupIds) {
            if (groupId.isSpecial()) {
                groups.put(groupId, QueryGroupConverter.toViewerGroup(groupId.getSpecialGroup()));
            } else {
                QueryGroup group = queryGroupService.getGroup(groupId);
                if (group != null) {
                    groups.put(groupId, QueryGroupConverter.toViewerGroup(group));
                }
            }
        }
        return groups;
    }
}
