package ru.yandex.webmaster3.viewer.http;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.Header;

import ru.yandex.wmtools.common.sita.SitaUrlFetchResponse;
import ru.yandex.wmtools.common.util.http.YandexHttpStatus;

/**
 * User: azakharov
 * Date: 19.06.14
 * Time: 17:55
 */
public class HttpResponse {
    private Integer httpCode;
    private List<HttpHeader> headers;
    private String body;

    public HttpResponse(final Integer httpCode, final List<HttpHeader> headers, final String body) {
        this.httpCode = httpCode;
        this.headers = headers;
        this.body = body;
    }

    public Integer getHttpCode() {
        return httpCode;
    }

    public List<HttpHeader> getHeaders() {
        return headers;
    }

    public String getBody() {
        return body;
    }

    public static class HttpHeader {
        private final String name;
        private final String value;

        public HttpHeader(final String name, final String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return name;
        }

        public String getValue() {
            return value;
        }
    }

    public static HttpResponse create(int code, Header[] headers, String documentContent) {
        List<HttpHeader> resultHeaders = null;
        if (headers != null) {
            resultHeaders = new ArrayList<>(headers.length);
            for (Header header : headers) {
                resultHeaders.add(new HttpHeader(header.getName(), header.getValue()));
            }
        }
        return new HttpResponse(code, resultHeaders, documentContent);
    }
}
