package ru.yandex.webmaster3.viewer.http;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.sitestructure.NewSiteStructure;

/**
 * @author aherman
 */
public interface SiteTreeNodeAware {
    @Description(value="Идентификатор раздела сайта")
    @RequestQueryProperty
    public void setNodeId(long nodeId);

    public Long getNodeId();

    default public long getNodeIdOrRoot() {
        Long nodeId = getNodeId();
        if (nodeId == null) {
            return NewSiteStructure.ROOT_NODE_ID;
        }
        return nodeId;
    }
}
