package ru.yandex.webmaster3.viewer.http.abt;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.abt.AbtService;
import ru.yandex.webmaster3.storage.abt.ExperimentMapperService;

/**
 * @author leonidrom
 */
@WriteAction
@Category("abt")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component("/abt/cleanCache")
public class CleanExperimentsCacheAction extends Action<CleanExperimentsCacheAction.Request, CleanExperimentsCacheAction.Response> {
    private final AbtService abtService;
    private final ExperimentMapperService experimentMapperService;

    @Override
    public Response process(Request request) throws WebmasterException {
        abtService.cleanExperimentsCache();
        experimentMapperService.cleanExperimentsCache();
        return new Response();
    }

    public static class Request implements ActionRequest {}
    public static class Response implements ActionResponse.NormalResponse {}
}
