package ru.yandex.webmaster3.viewer.http.abt;

import java.util.Collection;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.abt.AbtService;
import ru.yandex.webmaster3.storage.abt.model.SimpleExperiment;

/**
 * Копия ручки /experiment/all из воркера
 */
@ReadAction
@Category("abt")
@Component("/abt/listDetails")
@AllArgsConstructor(onConstructor_ = @Autowired)
public class GetExperimentsDetailsAction extends Action<GetExperimentsDetailsAction.Req, GetExperimentsDetailsAction.Res> {
    private final AbtService abtService;

    @Override
    public GetExperimentsDetailsAction.Res process(GetExperimentsDetailsAction.Req request) throws WebmasterException {
        var simpleExperiments = abtService.listAllExperiments();
        return new GetExperimentsDetailsAction.Res(simpleExperiments.values());
    }

    public static class Req implements ActionRequest {
    }

    @Getter
    @AllArgsConstructor
    public static class Res implements ActionResponse.NormalResponse {
        private final Collection<SimpleExperiment> experiments;
    }
}
