package ru.yandex.webmaster3.viewer.http.achievements;

import java.util.Set;

import lombok.AllArgsConstructor;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.achievements.model.AchievementType;

/**
 * Created by Oleg Bazdyrev on 05/10/2018.
 */
public abstract class AddHostAchievementsRivalResponse implements ActionResponse {

    public enum ErrorCode {
        ADD_HOST_ACHIEVEMENTS_RIVAL__INVALID_URL,
        ADD_HOST_ACHIEVEMENTS_RIVAL__RIVAL_ALREADY_ADDED,
        ADD_HOST_ACHIEVEMENTS_RIVAL__TOO_MANY_RIVALS,;
    }

    @AllArgsConstructor
    public static final class NormalResponse extends AddHostAchievementsRivalResponse implements ActionResponse.NormalResponse {
        private final RivalAchievements rivalAchievements;
        private final Set<AchievementType> allAchievementTypes;

        @Description("Ачивки свежедобавленного хоста")
        public RivalAchievements getRivalAchievements() {
            return rivalAchievements;
        }

        @Description("Все возможные типы ачивок для переданного TLD")
        public Set<AchievementType> getAllAchievementTypes() {
            return allAchievementTypes;
        }
    }

    @Description("Кривой урл")
    public static final class InvalidUrlResponse extends AddHostAchievementsRivalResponse
            implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return ErrorCode.ADD_HOST_ACHIEVEMENTS_RIVAL__INVALID_URL;
        }
    }

    @Description("Конкурент уже добавлен")
    public static final class RivalAlreadyAddedResponse extends AddHostAchievementsRivalResponse
            implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return ErrorCode.ADD_HOST_ACHIEVEMENTS_RIVAL__RIVAL_ALREADY_ADDED;
        }
    }

    @Description("Слишком много конкурентов")
    public static final class TooManyRivalsResponse extends AddHostAchievementsRivalResponse
            implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return ErrorCode.ADD_HOST_ACHIEVEMENTS_RIVAL__TOO_MANY_RIVALS;
        }
    }

}
