package ru.yandex.webmaster3.viewer.http.achievements;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.achievements.model.AchievementInfo;
import ru.yandex.webmaster3.storage.achievements.model.AchievementProblem;
import ru.yandex.webmaster3.storage.achievements.model.AchievementType;

import java.util.List;
import java.util.Set;

/**
 * Created by Oleg Bazdyrev on 24/08/2018.
 */
public class GetAchievementsResponse implements ActionResponse.NormalResponse {

    private final String hostName;
    private final List<AchievementInfo> achievements;
    private final List<AchievementProblem> problems;
    private final boolean canHaveSqi;
    private final Set<AchievementType> allAchievementTypes;

    public GetAchievementsResponse(String hostName, List<AchievementInfo> achievements,
                                   List<AchievementProblem> problems, boolean canHaveSqi,
                                   Set<AchievementType> allAchievementTypes) {
        this.hostName = hostName;
        this.achievements = achievements;
        this.problems = problems;
        this.canHaveSqi = canHaveSqi;
        this.allAchievementTypes = allAchievementTypes;
    }

    @Description("Для какого хоста показываем ачивки")
    public String getHostName() {
        return hostName;
    }

    @Description("Список ачивок хоста")
    public List<AchievementInfo> getAchievements() {
        return achievements;
    }

    @Description("Проблемы хоста")
    public List<AchievementProblem> getProblems() {
        return problems;
    }

    @Description("Может ли данный TLD иметь данные про ИКС")
    public boolean isCanHaveSqi() {
        return canHaveSqi;
    }

    @Description("Все возможные типы ачивок для переданного TLD")
    public Set<AchievementType> getAllAchievementTypes() {
        return allAchievementTypes;
    }
}
