package ru.yandex.webmaster3.viewer.http.achievements;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.searchquery.OrderDirection;
import ru.yandex.webmaster3.storage.achievements.model.AchievementTld;
import ru.yandex.webmaster3.storage.achievements.model.AchievementType;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

import java.util.Comparator;
import java.util.function.Function;

/**
 * Created by Oleg Bazdyrev on 05/10/2018.
 */
public final class GetHostAndRivalsAchievementsRequest extends AbstractUserVerifiedHostRequest {

    private AchievementTld tld = AchievementTld.RU;
    private Field orderBy;
    private OrderDirection orderDirection = OrderDirection.ASC;

    public AchievementTld getTld() {
        return tld;
    }

    @RequestQueryProperty
    public void setTld(AchievementTld tld) {
        this.tld = tld;
    }

    public Field getOrderBy() {
        return orderBy;
    }

    @RequestQueryProperty
    @Description("По какому полю сортировать")
    public void setOrderBy(Field orderBy) {
        this.orderBy = orderBy;
    }

    public OrderDirection getOrderDirection() {
        return orderDirection;
    }

    @RequestQueryProperty
    @Description("Как сортировать")
    public void setOrderDirection(OrderDirection orderDirection) {
        this.orderDirection = orderDirection;
    }

    public enum Field {
        HOST(RivalAchievements::getHost),
        SQI(row -> row.getAchievements().get(AchievementType.SQI)),
        USER_CHOICE(row -> row.getAchievements().get(AchievementType.USER_CHOICE)),
        POPULAR(row -> row.getAchievements().get(AchievementType.POPULAR)),
        ;

        private final Function<RivalAchievements, Comparable<?>> valueExtractor;

        Field(Function<RivalAchievements, Comparable<?>> valueExtractor) {
            this.valueExtractor = valueExtractor;
        }

        public Function<RivalAchievements, Comparable<?>> getValueExtractor() {
            return valueExtractor;
        }

        public Comparator<RivalAchievements> getComparator() {
            return Comparator.<RivalAchievements, Comparable>comparing(valueExtractor,
                    Comparator.nullsFirst(Comparator.naturalOrder()));
        }
    }

}
