package ru.yandex.webmaster3.viewer.http.achievements;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.achievements.model.AchievementInfo;
import ru.yandex.webmaster3.storage.achievements.model.AchievementProblem;
import ru.yandex.webmaster3.storage.achievements.model.AchievementType;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by Oleg Bazdyrev on 05/10/2018.
 */
public final class GetHostAndRivalsAchievementsResponse implements ActionResponse.NormalResponse {

    private final Map<AchievementType, AchievementInfo> hostAchievements;
    private final List<AchievementProblem> hostProblems;
    private final List<RivalAchievements> rivalAchievementsList;
    private final boolean canHaveSqi;
    private final Set<AchievementType> allAchievementTypes;

    public GetHostAndRivalsAchievementsResponse(Map<AchievementType, AchievementInfo> hostAchievements,
                                                List<AchievementProblem> hostProblems,
                                                List<RivalAchievements> rivalAchievementsList, boolean canHaveSqi,
                                                Set<AchievementType> allAchievementTypes) {
        this.hostAchievements = hostAchievements;
        this.hostProblems = hostProblems;
        this.rivalAchievementsList = rivalAchievementsList;
        this.canHaveSqi = canHaveSqi;
        this.allAchievementTypes = allAchievementTypes;
    }

    @Description("Ачивки искомого хоста")
    public Map<AchievementType, AchievementInfo> getHostAchievements() {
        return hostAchievements;
    }

    @Description("Проблемы искомого хоста")
    public List<AchievementProblem> getHostProblems() {
        return hostProblems;
    }

    @Description("Строки со всеми хостами-конкурентами и их ачивками")
    public List<RivalAchievements> getRivalAchievementsList() {
        return rivalAchievementsList;
    }

    @Description("Может ли данный TLD иметь данные про ИКС")
    public boolean isCanHaveSqi() {
        return canHaveSqi;
    }

    @Description("Все возможные типы ачивок для переданного TLD")
    public Set<AchievementType> getAllAchievementTypes() {
        return allAchievementTypes;
    }

}
