package ru.yandex.webmaster3.viewer.http.achievements;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.link.DatePoint;
import ru.yandex.webmaster3.viewer.http.links.DateHistory;

import java.util.List;

/**
 * @author lester
 */
public class GetHostAndRivalsSqiHistoryResponse implements ActionResponse.NormalResponse, DateHistory<String> {
    private final List<RivalSqiHistory> histories;

    public GetHostAndRivalsSqiHistoryResponse(List<RivalSqiHistory> histories) {
        this.histories = histories;
    }

    @Override
    public List<RivalSqiHistory> getHistories() {
        return histories;
    }

    public static class RivalSqiHistory implements History<String> {
        private final List<DatePoint> data;
        private final String owner;

        public RivalSqiHistory(String owner, List<DatePoint> data) {
            this.data = data;
            this.owner = owner;
        }

        @Override
        public String getIndicatorName() {
            return owner;
        }

        @Override
        public List<DatePoint> getData() {
            return data;
        }
    }
}
