package ru.yandex.webmaster3.viewer.http.achievements;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.achievements.dao.HostAchievementsRivalsYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;
import ru.yandex.webmaster3.viewer.http.achievements.RemoveHostAchievementsRivalAction.Request;
import ru.yandex.webmaster3.viewer.http.achievements.RemoveHostAchievementsRivalAction.Response;

/**
 * Created by Oleg Bazdyrev on 05/10/2018.
 */
@WriteAction
@Category("achievements")
@Description("Удаление конкурента для сравнения ачивок")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class RemoveHostAchievementsRivalAction extends AbstractUserVerifiedHostAction<Request, Response> {

    private final HostAchievementsRivalsYDao hostAchievementsRivalsYDao;

    @Override
    public Response process(Request request) {
        hostAchievementsRivalsYDao.removeRival(request.getHostId(), request.getRivalHost());
        return new Response();
    }

    public static final class Request extends AbstractUserVerifiedHostRequest {

        private String rivalHost;

        public String getRivalHost() {
            return rivalHost;
        }

        @RequestQueryProperty(required = true)
        @Description("Добавляемый хост (можно передать урл, но от него все равно останется только хост)")
        public void setRivalHost(String rivalHost) {
            this.rivalHost = rivalHost;
        }
    }

    public static final class Response implements ActionResponse.NormalResponse {

    }
}
