package ru.yandex.webmaster3.viewer.http.achievements;

import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.storage.achievements.model.AchievementInfo;
import ru.yandex.webmaster3.storage.achievements.model.AchievementType;
import ru.yandex.webmaster3.storage.services.ServiceInfo;
import ru.yandex.webmaster3.storage.services.SiteServiceType;
import ru.yandex.webmaster3.storage.ugc.SiteRating;

/**
 * Created by Oleg Bazdyrev on 08/10/2018.
 */
@AllArgsConstructor
@Getter
public final class RivalAchievements {

    @Description("Запрашиваемый хост (для выделения в списке)")
    private final boolean requestedHost;
    @Description("Имя хоста без схемы и пути")
    private final String host;
    @Description("Ачивки хоста по типам")
    private final Map<AchievementType, AchievementInfo> achievements;
    @Description("Количество турбо страниц в поиске")
    private final Long turboSearchPages;
    @Description("Сервисы хоста по типам")
    private final Map<SiteServiceType, ServiceInfo> services;
    @Description("Градусник")
    private final SiteRating siteRating;
    @Description("Товарная Вертикаль")
    private final boolean verticalShare;
}
