package ru.yandex.webmaster3.viewer.http.addurl;

import java.util.List;

import ru.yandex.webmaster3.core.addurl.UrlForRecrawl;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author aherman
 */
public abstract class AddUrlResponse implements ActionResponse {
    public static class NormalResponse extends AddUrlResponse implements ActionResponse.NormalResponse {
        private final int quota;
        private final int quotaUsed;
        private final int quotaRemain;
        private final List<UrlForRecrawl> urls;
        private final AddUrlWarningType warning;
        private final List<String> invalidUrls;

        public NormalResponse(int quota, int quotaUsed, int quotaRemain, List<UrlForRecrawl> urls, AddUrlWarningType warning,
                List<String> invalidUrls)
        {
            this.quota = quota;
            this.quotaUsed = quotaUsed;
            this.quotaRemain = quotaRemain;
            this.urls = urls;
            this.warning = warning;
            this.invalidUrls = invalidUrls;
        }

        public int getQuota() {
            return quota;
        }

        public int getQuotaUsed() {
            return quotaUsed;
        }

        public int getQuotaRemain() {
            return quotaRemain;
        }

        public List<UrlForRecrawl> getUrls() {
            return urls;
        }

        public AddUrlWarningType getWarning() {
            return warning;
        }

        public List<String> getInvalidUrls() {
            return invalidUrls;
        }
    }

    public enum AddUrlWarningType {
        ADD_URL__QUOTA_EXCEEDED,
        ADD_URL__INVALID_URLS,
    }

    public enum AddUrlErrorType {
        ADD_URL__QUOTA_EXCEEDED,
        ADD_URL__REQUEST_TOO_BIG,
    }

    public static class QuotaExceededResponse extends AddUrlResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;
        private final int quota;
        private final int quotaUsed;

        public QuotaExceededResponse(Class<?> clazz, int quota, int quotaUsed) {
            this.clazz = clazz;
            this.quota = quota;
            this.quotaUsed = quotaUsed;
        }

        @Override public Enum<?> getCode() {return AddUrlErrorType.ADD_URL__QUOTA_EXCEEDED;}
        @Override public Class<?> getClazz() {return clazz;}
        @Override public String getMessage() {return "Host quota exceeded: " + quotaUsed + " of " + quota;}

        public int getQuota() {return quota;}
        public int getQuotaUsed() {return quotaUsed;}
    }

    public static class RequestTooBigResponse extends AddUrlResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;

        public RequestTooBigResponse(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override public Enum<?> getCode() {return AddUrlErrorType.ADD_URL__REQUEST_TOO_BIG;}
        @Override public Class<?> getClazz() {return clazz;}
        @Override public String getMessage() {return "All urls are invalid";}
    }
}
