package ru.yandex.webmaster3.viewer.http.addurl;

import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.DailyQuotaUtil;
import ru.yandex.webmaster3.storage.addurl.AddUrlRequestsService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author tsyplyaev
 */
@ReadAction
@Category("addurl")
@Component("/addurl/quota")
public class GetRecrawlUrlQuotaAction extends AbstractUserVerifiedHostAction<GetRecrawlUrlQuotaAction.Request, GetRecrawlUrlQuotaAction.Response> {
    private final AddUrlRequestsService addUrlRequestsService;

    @Autowired
    public GetRecrawlUrlQuotaAction(AddUrlRequestsService addUrlRequestsService) {
        this.addUrlRequestsService = addUrlRequestsService;
    }

    @Override
    public Response process(Request request) {
        DailyQuotaUtil.QuotaUsage quotaUsage = addUrlRequestsService.getQuotaUsage(request.getHostId(), DateTime.now());
        return new Response(quotaUsage.getTodayQuota(), quotaUsage.getQuotaUsed(), quotaUsage.getQuotaRemain());
    }

    public static class Request extends AbstractUserVerifiedHostRequest {
    }

    public class Response implements ActionResponse.NormalResponse {
        private final int quota;
        private final int quotaUsed;
        private final int quotaRemain;

        public Response(int quota, int quotaUsed, int quotaRemain) {
            this.quota = quota;
            this.quotaUsed = quotaUsed;
            this.quotaRemain = quotaRemain;
        }

        public int getQuota() {
            return quota;
        }

        public int getQuotaUsed() {
            return quotaUsed;
        }

        public int getQuotaRemain() {
            return quotaRemain;
        }
    }
}
