package ru.yandex.webmaster3.viewer.http.addurl;

import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.webmaster3.core.addurl.UrlForRecrawl;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.PageUtils;
import ru.yandex.webmaster3.storage.addurl.AddUrlRequestsService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

import java.util.Collections;
import java.util.List;

/**
 * @author tsyplyaev
 */
@ReadAction
@Category("addurl")
@Component("/addurl/get")
public class GetRecrawlUrlRequestsAction extends AbstractUserVerifiedHostAction<GetRecrawlUrlRequestsAction.Request, GetRecrawlUrlResponse> {
    private final AddUrlRequestsService addUrlRequestsService;

    @Autowired
    public GetRecrawlUrlRequestsAction(AddUrlRequestsService addUrlRequestsService) {
        this.addUrlRequestsService = addUrlRequestsService;
    }

    @Override
    public GetRecrawlUrlResponse process(Request request) {
        int count = addUrlRequestsService.count(request.getHostId(), request.getFromDate(), request.getToDate());
        PageUtils.Pager page = PageUtils.getPage(request.getPage(), request.getPageSize(), count);
        if (page.isEmpty()) {
            return new GetRecrawlUrlResponse(count, Collections.emptyList());
        }

        List<UrlForRecrawl> urls = addUrlRequestsService.list(request.getHostId(), request.getFromDate(),
                request.getToDate(), page.toRangeStart(), page.getPageSize());

        return new GetRecrawlUrlResponse(count, urls);
    }

    public static class Request extends AbstractUserVerifiedHostRequest implements PagerAware {
        private int page = 0;
        private int pageSize = 25;
        private DateTime fromDate;
        private DateTime toDate;

        @Override
        public void setP(int page) {
            this.page = page;
        }

        @Override
        public void setPSize(int pageSize) {
            this.pageSize = pageSize;
        }

        public int getPage() {
            return page;
        }

        public int getPageSize() {
            return pageSize;
        }

        public DateTime getFromDate() {
            return fromDate;
        }

        @RequestQueryProperty
        public void setFromDate(DateTime fromDate) {
            this.fromDate = fromDate;
        }

        public DateTime getToDate() {
            return toDate;
        }

        @RequestQueryProperty
        public void setToDate(DateTime toDate) {
            this.toDate = toDate;
        }
    }
}
