package ru.yandex.webmaster3.viewer.http.announcement;

import java.util.Set;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Category;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.user.ServiceAnnouncement;
import ru.yandex.webmaster3.storage.user.service.AnnouncementService;
import ru.yandex.webmaster3.viewer.http.BaseWebmaster3Action;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;

@ReadAction
@Category("notifications")
@Description("Получить текст по категории и языку")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component("/messages/serviceAnnouncement/list")
public class GetServiceAnnouncementAction extends BaseWebmaster3Action<GetServiceAnnouncementAction.GetServiceAnnouncementRequest, GetServiceAnnouncementAction.GetServiceAnnouncementResponse> {

    private final AnnouncementService announcementService;

    @Override
    public GetServiceAnnouncementResponse process(GetServiceAnnouncementRequest request) {
        Set<ServiceAnnouncement> serviceAnnouncements = announcementService.getServiceAnnouncements(request.getRouteName(), true,
                request.getHostId(), request.getUserId());
        return new GetServiceAnnouncementResponse(serviceAnnouncements);
    }

    @Getter
    public static class GetServiceAnnouncementRequest extends AbstractFrontendRequest {
        @Setter(onMethod_ = @RequestQueryProperty(required = true))
        private String routeName;
        @Setter(onMethod_ = @RequestQueryProperty(required = false))
        private WebmasterHostId hostId;
        @Setter(onMethod_ = @RequestQueryProperty(required = false))
        private long userId;
    }

    @Value
    public static class GetServiceAnnouncementResponse implements ActionResponse.NormalResponse {
        Set<ServiceAnnouncement> serviceAnnouncement;
    }
}
