package ru.yandex.webmaster3.viewer.http.camelcase;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.host.moderation.camelcase.service.HostDisplayNameService;
import ru.yandex.webmaster3.viewer.W3CheckHostNameService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.camelcase.data.BeautyHostName;

/**
 * User: azakharov
 * Date: 29.07.14
 * Time: 18:53
 */
@WriteAction
@Description(value = "Отменяет заявку в случае, если она ещё не промодерирована")
@Category("camelcase")
public class CancelHostDisplayNameChangeAction
        extends AbstractUserVerifiedHostAction<CancelHostDisplayNameChangeRequest, CancelHostDisplayNameChangeResponse> {
    private W3CheckHostNameService w3checkHostNameService;
    private HostDisplayNameService hostDisplayNameService;

    @Override
    public CancelHostDisplayNameChangeResponse process(CancelHostDisplayNameChangeRequest request) throws
            WebmasterException {
        HostDisplayNameService.CancelDisplayNameChangeResult cancelResult =
                hostDisplayNameService.cancelDisplayNameChangeRequest(request.getHostId(), request.getRequestId(), request.getUserId());
        switch (cancelResult.status) {
            case REQUEST_NOT_FOUND:
                return new CancelHostDisplayNameChangeResponse.RequestNotFoundResponse();
            case UNABLE_TO_CANCEL:
                return new CancelHostDisplayNameChangeResponse.UnableToCancelResponse();
            case OK:
                BeautyHostName beautyHostName = w3checkHostNameService.getDisplayName(cancelResult.displayName);
                return new CancelHostDisplayNameChangeResponse.NormalResponse(beautyHostName);
            default:
                String message = "Unknown cancel display name change result status: " + cancelResult.status;
                throw new WebmasterException(message,
                        new WebmasterErrorResponse.InternalUnknownErrorResponse(this.getClass(), message));
        }
    }

    @Required
    public void setW3checkHostNameService(W3CheckHostNameService w3checkHostNameService) {
        this.w3checkHostNameService = w3checkHostNameService;
    }

    @Required
    public void setHostDisplayNameService(HostDisplayNameService hostDisplayNameService) {
        this.hostDisplayNameService = hostDisplayNameService;
    }
}
