package ru.yandex.webmaster3.viewer.http.camelcase;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.viewer.http.camelcase.data.BeautyHostName;

/**
 * User: azakharov
 * Date: 29.07.14
 * Time: 18:54
 */
public abstract class CancelHostDisplayNameChangeResponse implements ActionResponse {
    public static class NormalResponse extends CancelHostDisplayNameChangeResponse implements ActionResponse.NormalResponse {
        private BeautyHostName beautyHostName;

        public NormalResponse(BeautyHostName beautyHostName) {
            this.beautyHostName = beautyHostName;
        }

        public BeautyHostName getBeautyHostName() {
            return beautyHostName;
        }
    }

    public enum CancelDisplayNameChangeErrorType {
        CANCEL_DISPLAY_NAME_CHANGE__REQUEST_NOT_FOUND,
        CANCEL_DISPLAY_NAME_CHANGE__UNABLE_TO_CANCEL
    }

    public static class RequestNotFoundResponse extends CancelHostDisplayNameChangeResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return CancelDisplayNameChangeErrorType.CANCEL_DISPLAY_NAME_CHANGE__REQUEST_NOT_FOUND;
        }
    }

    public static class UnableToCancelResponse extends CancelHostDisplayNameChangeResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return CancelDisplayNameChangeErrorType.CANCEL_DISPLAY_NAME_CHANGE__UNABLE_TO_CANCEL;
        }
    }
}
