package ru.yandex.webmaster3.viewer.http.camelcase;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author aherman
 */
public class ChangeHostDisplayNameRequest extends AbstractUserVerifiedHostRequest {
    public static final String PARAM_DISPLAY_NAME = "displayName";

    private String displayName;
    private String userComment;

    @Description(value = "Желаемый вид имени хоста в поиске (без схемы, без порта, без www)")
    @RequestQueryProperty(required = true)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Description(value = "Комментарий пользователя")
    @RequestQueryProperty()
    public void setUserComment(String userComment) {
        this.userComment = userComment;
    }

    public String getUserComment() {
        return userComment;
    }

    public String getDisplayName() {
        return displayName;
    }
}
