package ru.yandex.webmaster3.viewer.http.camelcase;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.storage.host.moderation.camelcase.service.HostDisplayNameService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * User: azakharov
 * Date: 17.10.14
 * Time: 14:48
 */
@WriteAction
@Description(value = "Позволяет спрятать заявку в состоянии REFUSED")
@Category("camelcase")
public class HideRefusedHostDisplayNameStatusAction extends AbstractUserVerifiedHostAction<HideRefusedHostDisplayNameStatusRequest, HideRefusedHostDisplayNameStatusResponse> {
    private HostDisplayNameService hostDisplayNameService;

    @Override
    public HideRefusedHostDisplayNameStatusResponse process(HideRefusedHostDisplayNameStatusRequest request) {
        HostDisplayNameService.HideRefusedResultStatus hideStatus =
                hostDisplayNameService.hideRefusedRequest(request.getHostId(), request.getRequestId());
        switch (hideStatus) {
            case REQUEST_NOT_FOUND:
                return new HideRefusedHostDisplayNameStatusResponse.RequestNotFoundResponse();
            case UNABLE_TO_HIDE:
                return new HideRefusedHostDisplayNameStatusResponse.UnableToHideResponse();
            case OK:
                return new HideRefusedHostDisplayNameStatusResponse.OrdinaryResponse();
            default:
                String message = "Unknown hide refused status: " + hideStatus;
                throw new WebmasterException(message,
                        new WebmasterErrorResponse.InternalUnknownErrorResponse(this.getClass(), message));
        }
    }

    @Required
    public void setHostDisplayNameService(HostDisplayNameService hostDisplayNameService) {
        this.hostDisplayNameService = hostDisplayNameService;
    }
}
