package ru.yandex.webmaster3.viewer.http.camelcase;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * User: azakharov
 * Date: 17.10.14
 * Time: 14:49
 */
public abstract class HideRefusedHostDisplayNameStatusResponse implements ActionResponse {
    public static class OrdinaryResponse extends HideRefusedHostDisplayNameStatusResponse implements ActionResponse.NormalResponse {
    }

    public enum HideRefusedStatusErrorType {
        HIDE_REFUSED_STATUS__REQUEST_NOT_FOUND,
        HIDE_REFUSED_STATUS__UNABLE_TO_HIDE
    }

    public static class RequestNotFoundResponse extends HideRefusedHostDisplayNameStatusResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return HideRefusedStatusErrorType.HIDE_REFUSED_STATUS__REQUEST_NOT_FOUND;
        }
    }

    public static class UnableToHideResponse extends HideRefusedHostDisplayNameStatusResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return HideRefusedStatusErrorType.HIDE_REFUSED_STATUS__UNABLE_TO_HIDE;
        }
    }
}
