package ru.yandex.webmaster3.viewer.http.camelcase;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.viewer.http.camelcase.data.BeautyHostName;
import ru.yandex.webmaster3.viewer.http.camelcase.data.DisplayNameRequestView;

/**
* @author aherman
*/
public abstract class HostDisplayNameInfoResponse implements ActionResponse {
    public static class NormalResponse extends HostDisplayNameInfoResponse implements ActionResponse.NormalResponse {
        private final CurrentHostState currentHostState;
        private final DisplayNameRequestView displayNameRequest;
        private final DisplayNameRequestView pendingDisplayNameRequest;

        public NormalResponse(boolean isIDN,
                @NotNull BeautyHostName currentStateDisplayName,
                @Nullable DisplayNameRequestView displayNameRequest,
                @Nullable DisplayNameRequestView pendingDisplayNameRequest) {
            this.currentHostState = new CurrentHostState(currentStateDisplayName, isIDN);
            this.displayNameRequest = displayNameRequest;
            this.pendingDisplayNameRequest = pendingDisplayNameRequest;
        }

        public CurrentHostState getCurrentHostState() {
            return currentHostState;
        }

        public DisplayNameRequestView getDisplayNameRequest() {
            return displayNameRequest;
        }

        public DisplayNameRequestView getPendingDisplayNameRequest() {
            return pendingDisplayNameRequest;
        }
    }

    public enum ChangeDisplayNameErrorType {
        @Description("Нет данных от серпа, не разрешаем менять регистр, чтобы не допускать изменения, совпадающие с продакшеном")
        DISPLAY_NAME_INFO__NO_DATA_FOR_HOST
    }

    static abstract class BaseErrorResponse extends HostDisplayNameInfoResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;
        protected BaseErrorResponse(Class<?> clazz) {this.clazz = clazz;}
        @Override public Class<?> getClazz() {return clazz;}
    }

    public static class CurrentHostState {
        private final BeautyHostName beautyHostName;
        private final boolean isIDN;
        private final HostDisplayNameEditableStatus editableStatus;

        public CurrentHostState(BeautyHostName beautyHostName, boolean isIDN) {
            this.beautyHostName = beautyHostName;
            this.isIDN = isIDN;
            if (isIDN) {
                this.editableStatus = HostDisplayNameEditableStatus.NOT_EDITABLE__IDN;
            } else if (beautyHostName.getMain() == null) {
                this.editableStatus = HostDisplayNameEditableStatus.NOT_EDITABLE__FIXED_SPELLING;
            } else {
                this.editableStatus = HostDisplayNameEditableStatus.EDITABLE;
            }
        }

        public BeautyHostName getBeautyHostName() {
            return beautyHostName;
        }

        @Description("Deprecated. Использовать поле editableStatus")
        @Deprecated
        public boolean isIDN() {
            return isIDN;
        }

        @Description("Можно ли редактировать поле и если нельзя, то почему")
        public HostDisplayNameEditableStatus getEditableStatus() {
            return editableStatus;
        }
    }

    public enum HostDisplayNameEditableStatus {
        EDITABLE,
        NOT_EDITABLE__IDN,
        NOT_EDITABLE__FIXED_SPELLING
    }
}
