package ru.yandex.webmaster3.viewer.http.camelcase.data;

/**
 * User: azakharov
 * Date: 15.12.14
 * Time: 14:22
 */
public class BeautyHostName {
    private final String prefix;
    private final String main;
    private final String suffix;

    public BeautyHostName(String prefix, String main, String suffix) {
        this.prefix = prefix;
        this.main = main;
        this.suffix = suffix;
    }

    /**
     * Unmodifiable prefix of displayName like www, ftp, etc.
     * @return  prefix string
     */
    public String getPrefix() {
        return prefix;
    }

    /**
     * Main part of displayName, which is allowed to edit
     * @return  main part string
     */
    public String getMain() {
        return main;
    }

    /**
     * Unmodifiable suffix of displayName like .ru, .narod.ru, etc.
     * @return  suffix string
     */
    public String getSuffix() {
        return suffix;
    }

    /**
     * Builds full displayName from it's parts
     * @return  full displayName string
     */
    public String toFullDisplayName() {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix).append(".");
        }
        sb.append(main);
        sb.append(".").append(suffix);
        return sb.toString();
    }
}
